<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'vendor/autoload.php';

$smtpHost = getenv('SMTP_HOST') ?: 'mail.smtp2go.com';
$smtpUser = getenv('SMTP_USER') ?: 'dmxdigital';
$smtpPass = getenv('SMTP_PASS') ?: 'okQLYLleqoNP'; // Avoid hardcoding

$mail = new PHPMailer(true);

header('Content-Type: text/plain'); // Plain text response for JavaScript

try {

    if ($_SERVER["REQUEST_METHOD"] !== "POST") {
        http_response_code(405); // Method Not Allowed
        exit("Method Not Allowed");
    }

    // Get form data
    $name = strip_tags(trim($_POST["name"] ?? ''));
    $country_code = strip_tags(trim($_POST["qCountryCode"] ?? ''));
    $phone = strip_tags(trim($_POST["phone"] ?? ''));
    $email = filter_var(trim($_POST["email"] ?? ''), FILTER_SANITIZE_EMAIL);
    $message = strip_tags(trim($_POST["message"] ?? ''));
    $flag = strip_tags(trim($_POST["flag"] ?? '0'));
    $honeypot = trim($_POST["company_name"] ?? ''); // Honeypot field

    // 🛑 Spam Protection: If honeypot field is filled, block request
    if (!empty($honeypot)) {
        http_response_code(400);
        exit("Spam detected!");
    }

    if($flag==0) {
        // 🛑 Validate required fields
        if (!$name || !is_numeric($phone) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
            http_response_code(400);
            exit("Validation failed. Please check your input.");
        }
    }else{
        // 🛑 Validate required fields
        if (!$name || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
            http_response_code(400);
            exit("Validation failed. Please check your input.");
        }
    }

    // 🛑 Basic Spam Filter: Block messages with URLs
    if (preg_match('/(http:\/\/|https:\/\/|www\.)/i', $message) || preg_match('/(http:\/\/|https:\/\/|www\.)/i', $name)) {
        http_response_code(400);
        exit("Potential spam detected in message.");
    }

    $mail->isSMTP();
    $mail->Host       = $smtpHost;
    $mail->SMTPAuth   = true;
    $mail->Username   = $smtpUser;
    $mail->Password   = $smtpPass;
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port       = 2525;

    // Default message if empty
    if ($message == "") {
        $message = "Need Appointment";
    }

    // Email Details
    $mail->setFrom('lead@pages.dmxwebsites.com', 'Enquiry');
    $mail->addAddress('pathanparvez4@gmail.com', 'Enquiry');
    $mail->addReplyTo('paygudeaniket12@gmail.com', 'Aniket');

    // Content
    $mail->isHTML(true);
    $mail->Subject = "New Enquiry from Website";
    $mail->Body    = "
        <html>
        <head><title>New Enquiry</title></head>
        <body>
            <b>New Enquiry:</b><br>
            <b>Name:</b> " . htmlspecialchars($_POST['name'] ?? "-") . "<br>
            <b>Email:</b> " . htmlspecialchars($_POST['email'] ?? "-") . "<br>
            <b>Phone:</b> " . htmlspecialchars($_POST['country_code'] ?? "") . " " . htmlspecialchars($_POST['phone'] ?? "-") . "<br>
            <b>Message:</b> " . nl2br(htmlspecialchars($_POST['message'] ?? "-")) . "
        </body>
        </html>
    ";

    // Send Email
    $mail->send();
    http_response_code(200);
    exit("OK");

} catch (Exception $e) {
    error_log("Mailer Error: " . $mail->ErrorInfo);
    http_response_code(500);
    exit("An error occurred while sending your message.");
}